/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import novamachina.exnihilosequentia.common.compat.jei.sieve.JEISieveRecipe;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.item.OreItem;
import novamachina.exnihilosequentia.common.item.mesh.MeshType;
import novamachina.exnihilosequentia.common.item.ore.Ore;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import novamachina.exnihilosequentia.common.utility.IngredientUtils;
import org.apache.logging.log4j.LogManager;

public class SieveRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final boolean flattenRecipes = Config.flattenSieveRecipes();
    @Nonnull
    private final List<SieveRecipe> recipeList = new ArrayList<SieveRecipe>();
    @Nonnull
    private final Map<Boolean, Map<MeshType, Map<Block, Boolean>>> blockSiftableCache = new HashMap<Boolean, Map<MeshType, Map<Block, Boolean>>>();
    @Nonnull
    private final Map<Boolean, Map<MeshType, Map<Item, List<SieveRecipe>>>> itemDropsListCache = new HashMap<Boolean, Map<MeshType, Map<Item, List<SieveRecipe>>>>();

    @Nonnull
    private List<SieveRecipe> getDropsByIngredient(@Nonnull Ingredient input, @Nonnull MeshType meshType, boolean isWaterlogged) {
        this.generateCache(input, meshType, isWaterlogged);
        return this.recipeList.parallelStream().filter(sieveRecipe -> sieveRecipe.isWaterlogged() == isWaterlogged).filter(sieveRecipe -> IngredientUtils.areIngredientsEqual(sieveRecipe.getInput(), input)).map(recipe -> recipe.filterByMesh(meshType, this.flattenRecipes)).filter(recipe -> {
            if (recipe.getDrop().m_41720_() instanceof OreItem) {
                Ore ore = ((OreItem)recipe.getDrop().m_41720_()).getOre();
                return ore.isEnabled();
            }
            return true;
        }).filter(recipe -> !recipe.getRolls().isEmpty()).collect(Collectors.toList());
    }

    private void generateCache(@Nonnull Ingredient input, @Nonnull MeshType meshType, boolean isWaterlogged) {
        Arrays.stream(input.m_43908_()).map(ItemStack::m_41720_).forEach(item -> this.getDrops((ItemLike)item, meshType, isWaterlogged));
    }

    @Nonnull
    public List<SieveRecipe> getDrops(@Nonnull ItemLike input, @Nonnull MeshType meshType, boolean isWaterlogged) {
        return this.itemDropsListCache.computeIfAbsent(isWaterlogged, k -> new HashMap()).computeIfAbsent(meshType, k -> new HashMap()).computeIfAbsent(input.m_5456_(), k -> {
            ItemStack itemStack = new ItemStack((ItemLike)k);
            return this.recipeList.stream().filter(sieveRecipe -> sieveRecipe.isWaterlogged() == isWaterlogged).filter(sieveRecipe -> sieveRecipe.getInput().test(itemStack)).map(recipe -> recipe.filterByMesh(meshType, this.flattenRecipes)).filter(recipe -> !recipe.getRolls().isEmpty()).filter(recipe -> {
                if (recipe.getDrop().m_41720_() instanceof OreItem) {
                    Ore ore = ((OreItem)recipe.getDrop().m_41720_()).getOre();
                    return ore.isEnabled();
                }
                return true;
            }).collect(Collectors.toList());
        });
    }

    public boolean isBlockSiftable(@Nonnull Block block, @Nonnull MeshType mesh, boolean isWaterlogged) {
        return this.blockSiftableCache.computeIfAbsent(isWaterlogged, k -> new HashMap()).computeIfAbsent(mesh, k -> new HashMap()).computeIfAbsent(block, k -> {
            ItemStack itemStack = new ItemStack((ItemLike)block);
            int meshlevel = mesh.getLevel();
            return this.recipeList.stream().filter(sieveRecipe -> sieveRecipe.isWaterlogged() == isWaterlogged).filter(sieveRecipe -> sieveRecipe.getInput().test(itemStack)).anyMatch(sieveRecipe -> sieveRecipe.getRolls().stream().anyMatch(meshWithChance -> {
                int meshWithChanceId = meshWithChance.getMesh().getLevel();
                if (this.flattenRecipes) {
                    return meshWithChanceId <= meshlevel;
                }
                return meshWithChanceId == meshlevel;
            }));
        });
    }

    @Nonnull
    private List<JEISieveRecipe> getRecipeList(boolean isWaterLogged) {
        HashSet ingredients = new HashSet();
        this.recipeList.forEach(recipe -> {
            Ingredient recipeIngredient = recipe.getInput();
            if (ingredients.stream().noneMatch(ingredient -> IngredientUtils.areIngredientsEqual(ingredient, recipeIngredient))) {
                ingredients.add(recipeIngredient);
            }
        });
        return Arrays.stream(MeshType.values()).filter(enumMesh -> enumMesh != MeshType.NONE).flatMap(enumMesh -> {
            ItemStack mesh = new ItemStack((ItemLike)MeshItem.getMesh(enumMesh));
            return ingredients.stream().flatMap(ingredient -> {
                List<SieveRecipe> drops = this.getDropsByIngredient((Ingredient)ingredient, (MeshType)((Object)enumMesh), isWaterLogged);
                if (drops.isEmpty()) {
                    return null;
                }
                ArrayList<List> input = new ArrayList<List>(Arrays.asList(Collections.singletonList(mesh), Arrays.asList(ingredient.m_43908_())));
                return Lists.partition(drops, (int)21).stream().map(results -> new JEISieveRecipe((List<List<ItemStack>>)input, (List<SieveRecipe>)results));
            });
        }).collect(Collectors.toList());
    }

    @Nonnull
    public List<JEISieveRecipe> getDryRecipeList() {
        return this.getRecipeList(false);
    }

    @Nonnull
    public List<JEISieveRecipe> getWetRecipeList() {
        return this.getRecipeList(true);
    }

    public void setRecipes(@Nonnull List<SieveRecipe> recipes) {
        logger.debug("Sieve Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.blockSiftableCache.clear();
        this.itemDropsListCache.clear();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.blockSiftableCache.clear();
        this.itemDropsListCache.clear();
    }
}

